import json
import os
import uuid
from flask import Flask, redirect, render_template, request
from glob import glob
from pathlib import Path

app = Flask(__name__)

# Ensure data directory exists
DATA_DIR = Path("data")
DATA_DIR.mkdir(exist_ok=True)

SPORTS = [
    "Basketball",
    "Soccer",
    "Ultimate Frisbee"
]

@app.route("/")
def index():
    return render_template("index.html", sports=SPORTS)



@app.route("/deregister", methods=["POST"])
def deregister():
    # Forget registrant
    id = request.form.get("id")
    if id:
        file_path = DATA_DIR / f"{id}.json"
        if file_path.exists():
            with open(file_path) as f:
                reg = json.load(f)
                reg["sports"].remove(request.form.get("sport"))
                with open(file_path, "w") as g:
                    json.dump(reg, g)

    return redirect("/registrants")



@app.route("/register", methods=["POST"])
def register():
    # Validate name
    name = request.form.get("name")
    if not name:
        return render_template("error.html", message="Missing name")

    # Validate sports
    sports = request.form.getlist("sport")
    if not sports:
        return render_template("error.html", message="Missing sport")
    for sport in sports:
        if sport not in SPORTS:
            return render_template("error.html", message="Invalid sport")

    # Create registrant with UUID
    registrant = {
        "id": str(uuid.uuid4()),
        "name": name,
        "sports": sports
    }

    # Save to JSON file
    with open(DATA_DIR / f"{registrant['id']}.json", "w") as f:
        json.dump(registrant, f)

    return redirect("/registrants")

@app.route("/registrants")
def registrants():
    # Collect all registrants
    flat_registrants = []
    for file_path in DATA_DIR.glob("*.json"):
        with open(file_path) as f:
            reg = json.load(f)
            # Flatten sports list for template
            for sport in reg["sports"]:
                flat_registrants.append({
                    "id": reg["id"],
                    "name": reg["name"],
                    "sport": sport
                })

    return render_template("registrants.html", registrants=flat_registrants)
